/*
 * ClockApp.java
 */

package digitalclock.autonomous;

import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;

/**
 * The main class of the application.
 */
public class ClockApp extends SingleFrameApplication {

    /**
     * At startup create and show the main frame of the application.
     */
    @Override protected void startup() {
        clockView = new ClockView(this);
        show(clockView);
    }

    /**
     * This method is to initialize the specified window by injecting resources.
     * Windows shown in our application come fully initialized from the GUI
     * builder, so this additional configuration is not needed.
     */
    @Override protected void configureWindow(java.awt.Window root) {
    }

    /**
     * A convenient static getter for the application instance.
     * @return the instance of ClockApp
     */
    public static ClockApp getApplication() {
        return Application.getInstance(ClockApp.class);
    }

    @Override
    protected void ready() {
        getContext().getTaskService().execute(clockView.new ClockTask(500L));
    }

    /**
     * Main method launching the application.
     */
    public static void main(String[] args) {
        launch(ClockApp.class, args);
    }
    
    private ClockView clockView;
}
